import ApiService from "@/services/ApiService";

const baseUrl = "placas-frecuentes";

export const getAll = async (params = {}) => {
  const response = await ApiService.get(`${baseUrl}`, { params });
  return response.data;
};

export const createPlacaFrecuente = async (params) => {
  const response = await ApiService.post(`${baseUrl}`, params);
  return response.data;
};

export const getPlacaFrecuenteById = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const updatePlacaFrecuente = async (id, params) => {
  const response = await ApiService.put(`${baseUrl}/${id}`, params);
  return response.data;
};

export const deletePlacaFrecuente = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

