import ApiService from "@/services/ApiService";

const baseUrl = "tipos-carga";

export const getAll = async (params = {}) => {
  const response = await ApiService.get(`${baseUrl}`, { params });
  return response.data;
};

export const createTipoCarga = async (params) => {
  const response = await ApiService.post(`${baseUrl}`, params);
  return response.data;
};

export const getTipoCargaById = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const updateTipoCarga = async (id, params) => {
  const response = await ApiService.put(`${baseUrl}/${id}`, params);
  return response.data;
};

export const deleteTipoCarga = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

